'use strict';

exports.__esModule = true;
exports.fontFace = exports.inserted = exports.sheet = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.flush = flush;
exports.css = css;
exports.injectGlobal = injectGlobal;
exports.keyframes = keyframes;
exports.hydrate = hydrate;
exports.objStyle = objStyle;

var _sheet = require('./sheet');

var _hash = require('./hash');

var _utils = require('./utils');

var sheet = exports.sheet = new _sheet.StyleSheet();
sheet.inject();

var inserted = exports.inserted = {};

function values(cls, vars) {
  var hash = (0, _hash.hashArray)([cls].concat(vars));
  var varCls = 'vars-' + hash;
  if (inserted[hash]) {
    return varCls;
  }
  var src = '';
  (0, _utils.forEach)(vars, function (val, i) {
    src && (src += '; ');
    src += '--' + cls + '-' + i + ': ' + val;
  });
  sheet.insert('.' + varCls + ' {' + src + '}');
  inserted[hash] = true;

  return varCls;
}

function flush() {
  sheet.flush();
  exports.inserted = inserted = {};
  sheet.inject();
}

function css(classes, vars, content) {
  if (!Array.isArray(classes)) {
    classes = [classes];
  }

  var computedClassName = '';
  (0, _utils.forEach)(classes, function (cls) {
    computedClassName && (computedClassName += ' ');
    computedClassName += typeof cls === 'string' ? cls : objStyle(cls);
  });

  if (content) {
    // inline mode
    var src = content.apply(undefined, vars); // returns an array
    var hash = (0, _hash.hashArray)(src);

    if (!inserted[hash]) {
      inserted[hash] = true;
      var rgx = new RegExp(classes[0], 'gm');
      (0, _utils.forEach)(src, function (r) {
        sheet.insert(r.replace(rgx, classes[0] + '-' + hash));
      });
    }
    return classes[0] + '-' + hash + ' ' + computedClassName;
  }

  return computedClassName + (vars && vars.length > 0 ? ' ' + values(classes[0], vars) : '');
}

function injectGlobal(src) {
  var hash = (0, _hash.hashArray)(src);
  if (!inserted[hash]) {
    inserted[hash] = true;
    (0, _utils.forEach)(src, function (r) {
      return sheet.insert(r);
    });
  }
}

var fontFace = exports.fontFace = injectGlobal;

function keyframes(kfm, src) {
  var hash = (0, _hash.hashArray)(src);
  var animationName = kfm + '-' + hash;
  if (!inserted[hash]) {
    inserted[hash] = true;
    (0, _utils.forEach)(src, function (r) {
      return sheet.insert('@keyframes ' + animationName + ' ' + r);
    });
  }
  return animationName;
}

function hydrate(ids) {
  (0, _utils.forEach)(ids, function (id) {
    return inserted[id] = true;
  });
}

// 🍩
// https://github.com/jxnblk/cxs/blob/master/src/monolithic/index.js
function objStyle(style) {
  var hash = (0, _hash.hashObject)(style);
  var className = 'css-' + hash;
  var selector = '.' + className;

  if (inserted[hash]) return className;

  var rules = deconstruct(selector, style);
  (0, _utils.forEach)(rules, function (rule) {
    return sheet.insert(rule);
  });

  inserted[hash] = true;

  return className;
}

function deconstruct(selector, styles, media) {
  var decs = [];
  var rules = [];

  var _loop = function _loop(key) {
    var value = styles[key];
    var type = typeof value === 'undefined' ? 'undefined' : _typeof(value);

    if (type === 'number' || type === 'string') {
      decs.push(createDec(key, value));
    } else if (Array.isArray(value)) {
      (0, _utils.forEach)(value, function (val) {
        return decs.push(createDec(key, val));
      });
    } else if (key.charCodeAt(0) === 58) {
      (0, _utils.forEach)(deconstruct(selector + key, value, media), function (r) {
        return rules.push(r);
      });
    } else if (key.indexOf('@media') !== -1) {
      (0, _utils.forEach)(deconstruct(selector, value, key), function (r) {
        return rules.push(r);
      });
    } else {
      (0, _utils.forEach)(deconstruct(selector + ' ' + key, value, media), function (r) {
        return rules.push(r);
      });
    }
  };

  for (var key in styles) {
    _loop(key);
  }

  rules.unshift(createRule(selector, decs, media));

  return rules;
}

function createDec(key, value) {
  var prop = hyphenate(key);
  var val = addPx(key, value);
  return prop + ':' + val;
}

function createRule(selector, decs, media) {
  var rule = selector + '{' + decs.join(';') + '}';
  return media ? media + '{' + rule + '}' : rule;
}

function hyphenate(str) {
  return ('' + str).replace(/[A-Z]|^ms/g, '-$&').toLowerCase();
}

function addPx(prop, value) {
  if (typeof value !== 'number' || unitlessProps[prop] !== undefined) return value;
  return value + 'px';
}

var unitlessProps = {
  animationIterationCount: 1,
  boxFlex: 1,
  boxFlexGroup: 1,
  boxOrdinalGroup: 1,
  columnCount: 1,
  flex: 1,
  flexGrow: 1,
  flexPositive: 1,
  flexShrink: 1,
  flexNegative: 1,
  flexOrder: 1,
  gridRow: 1,
  gridColumn: 1,
  fontWeight: 1,
  lineClamp: 1,
  lineHeight: 1,
  opacity: 1,
  order: 1,
  orphans: 1,
  tabSize: 1,
  widows: 1,
  zIndex: 1,
  zoom: 1,
  fillOpacity: 1,
  stopOpacity: 1,
  strokeDashoffset: 1,
  strokeOpacity: 1,
  strokeWidth: 1
};