'use strict';

exports.__esModule = true;
exports.objStyle = exports.hydrate = exports.keyframes = exports.fontFace = exports.injectGlobal = exports.css = exports.flush = undefined;

var _index = require('./index');

Object.defineProperty(exports, 'flush', {
  enumerable: true,
  get: function get() {
    return _index.flush;
  }
});
Object.defineProperty(exports, 'css', {
  enumerable: true,
  get: function get() {
    return _index.css;
  }
});
Object.defineProperty(exports, 'injectGlobal', {
  enumerable: true,
  get: function get() {
    return _index.injectGlobal;
  }
});
Object.defineProperty(exports, 'fontFace', {
  enumerable: true,
  get: function get() {
    return _index.fontFace;
  }
});
Object.defineProperty(exports, 'keyframes', {
  enumerable: true,
  get: function get() {
    return _index.keyframes;
  }
});
Object.defineProperty(exports, 'hydrate', {
  enumerable: true,
  get: function get() {
    return _index.hydrate;
  }
});
Object.defineProperty(exports, 'objStyle', {
  enumerable: true,
  get: function get() {
    return _index.objStyle;
  }
});
exports.extractCritical = extractCritical;

var _utils = require('./utils');

var RGX = /css(?:[a-zA-Z0-9-]*)-([a-zA-Z0-9]+)/gm;

function extractCritical(html) {
  // parse out ids from html
  // reconstruct css/rules/cache to pass
  var o = { html: html, ids: [], css: '', rules: [] };
  var match = void 0;
  var ids = {};
  while ((match = RGX.exec(html)) !== null) {
    if (!ids[match[1]]) {
      ids[match[1]] = true;
    }
  }

  o.rules = _index.sheet.sheet.cssRules.slice().filter(function (x) {
    var match = RGX.exec(x.cssText);
    return match == null || ids[match[1]] || false;
  });

  o.ids = (0, _utils.keys)(_index.inserted).filter(function (id) {
    return !!ids[id];
  });

  var css = '';
  (0, _utils.forEach)(o.rules, function (x) {
    return css += x.cssText;
  });
  o.css = css;

  return o;
}