'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderToElement;

var _felaUtils = require('fela-utils');

var _renderToString = require('./renderToString');

var _renderToString2 = _interopRequireDefault(_renderToString);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function renderToElement(renderer, mountNode) {
  // mountNode must be a valid HTML element to be able
  // to set mountNode.textContent later on
  if (!(0, _felaUtils.isValidHTMLElement)(mountNode)) {
    throw new Error('You need to specify a valid element node (mountNode.nodeType = 1) to render into.');
  }

  var css = (0, _renderToString2.default)(renderer);

  if (mountNode.textContent !== css) {
    // render currently rendered styles to the DOM once
    mountNode.textContent = css;
  }

  return renderer.subscribe(function () {
    mountNode.textContent = (0, _renderToString2.default)(renderer);
  });
}