import { renderToElement } from 'fela-tools';

import createDOMInterface from './DOMInterface';
import initStyleNodes from './initStyleNodes';

var warnDeprecated = false;

export default function render(renderer, mountNode) {
  // legacy support for single stylesheets
  // will be removed soon
  if (mountNode) {
    if (!warnDeprecated) {
      // TODO: warn
      warnDeprecated = true;
    }

    renderToElement(renderer, mountNode);
  } else {
    initStyleNodes(renderer);
    var updateInterface = createDOMInterface(renderer);
    renderer.subscribe(updateInterface);
  }
}